 aR  w Q mP9      h	 oP      nSystem-wide$NOLIST 
$COMPACT

MODULE Menus;

$INCLUDE (``Incs_Pas`Con_Pas~Inc~)

$INCLUDE (``Incs_Pas`Common~Inc~)
$INCLUDE (``Incs_Pas`String_T~Inc~)
$INCLUDE (``Incs_Pas`String_P~Inc~)
$INCLUDE (``Incs_Pas`Window_T~Inc~)
$INCLUDE (``Incs_Pas`Window_P~Inc~)

$INCLUDE (``Incs_Pad`Events~Inc~)
$INCLUDE (``Incs_Pad`Graphics~Inc~)
$INCLUDE (``Incs_Pad`Menus~Inc~)
$INCLUDE (``Incs_Pad`Overlay~Inc~)
$INCLUDE (``Incs_Pad`Utility~Inc~)

$INCLUDE (``Incs_Pas`Library~Inc~)
$EJ

{-----------------------------------------------------------}

PUBLIC Menus;
CONST
  menuLineGap   = 2;
  maxMenus      = 10;
  maxMenuItems  = 32;
  maxMenuItemID = 64;
  maxMenuIDs    = 5;

  menuItemMask  = 0FFC0H;
  idMask        = 3FH;

TYPE
  MenuBarType = RECORD
                barRect:      Rectangle;
                numMenus:     WORD;
                numMenuIDs:   WORD;
                cmdKeys:      StringPtr;
                curMenu:      WORD; {currently highlighted menu: 0 = none}
                curItem:      WORD; {current item in curMenu: 0 = none}
                savedBits:    WindowRegionPtr; {bits behind curMenu}
                textRect:     Rectangle; {text area of curMenu}
                obscuredRect: Rectangle; {total area of curMenu}
                menu:         ARRAY [1..maxMenus] OF MenuType;
                menuIDs:      ARRAY [1..maxMenuIDs] OF WORD;
                END;

  MenuType =    RECORD
                titleRect:  Rectangle;
                items:      StringPtr;
                numItems:   WORD;
                maxItemLen: WORD;
                enableBits: LONGINT;
                END;

VAR
  menuBar: MenuBarType;
$EJ

PRIVATE Menus;

{-----------------------------------------------------------}
{                      SetMenuItemsID                       }
{-----------------------------------------------------------}

PROCEDURE SetMenuItemsID (thisMenu, thisItem, theID: WORD);
BEGIN
WITH menuBar DO
  IF (numMenuIDs < maxMenuIDs) AND
     (thisMenu <= numMenus) AND
     (theID <= maxMenuItemID) THEN
    BEGIN
    IF (thisItem <= menu[thisMenu].numItems) THEN
      BEGIN
      numMenuIDs := numMenuIDs + 1;
      menuIDs [numMenuIDs] := (thisMenu * 2048) + (thisItem * 64) + theID;
      END;
    END;
END;

{-----------------------------------------------------------}
{                      MenuItemEnabled                      }
{-----------------------------------------------------------}

FUNCTION MenuItemEnabled (thisItem: WORD): Boolean;
BEGIN
WITH menuBar DO
  MenuItemEnabled := NOT TestBitLongInt (menu[curMenu].enableBits, thisItem);
END;

{-----------------------------------------------------------}
{                      MenuDisableItem                      }
{-----------------------------------------------------------}

PROCEDURE MenuDisableItem (thisMenu, thisItem: WORD; disable: Boolean);
BEGIN
WITH menuBar DO
  IF (thisMenu <= maxMenus) THEN
    SetBitLongInt (menu[thisMenu].enableBits, thisItem, disable);
END;
$EJ

{-----------------------------------------------------------}
{                       MenuInit                            }
{-----------------------------------------------------------}

PROCEDURE MenuInit;
BEGIN
menuBar.numMenus := 0;
menuBar.numMenuIDs := 0;
menuBar.barRect.topLeft.x := 0;
menuBar.barRect.topLeft.y := 0;
menuBar.curMenu := 0;
menuBar.curItem := 0;
menuBar.cmdKeys := NIL;
WinGetWindowExtent (menuBar.barRect.extent);
menuBar.barRect.extent.y  := LineHeight + 4;
END;

{-----------------------------------------------------------}
{                     MenuLineHeight                        }
{-----------------------------------------------------------}

FUNCTION MenuLineHeight: Integer;
BEGIN
MenuLineHeight := LineHeight + menuLineGap;
END;
$EJ

{-----------------------------------------------------------}
{                     MenuBarRoutine                        }
{-----------------------------------------------------------}

PROCEDURE MenuBarRoutine (menuStr: StringPtr);
VAR
  maxLen,i:           WORD;
  titleLen:           Integer;   { This is here to avoid calling Tq_100 }
  title:              StringPtr;
  endOfLastTitleRect: INTEGER;

BEGIN
turncursoroff;
{------------------------------------}
{ start by deleting existing menuBar }
{------------------------------------}
WinEraseRectangle (menuBar.barRect);
menuBar.numMenus := 0;

{---------------------------------}
{ parse menuStr to create new bar }
{---------------------------------}
IF (menuStr^.len <> 0) THEN
  BEGIN
  endOfLastTitleRect := CharWidth;
  IF (menuStr^.chars[menuStr^.len] <> '|')
    THEN AppendAnyChar (menuStr, '|');
  menuBar.numMenus := ItemCount (menuStr^.chars, menuStr^.len, '|', maxLen);
  FOR i := 1 TO menuBar.numMenus DO
    BEGIN
    title := SubStringLit (menuStr^.chars,'|',i);
    menuBar.menu[i].items := NIL;
    WITH menuBar.menu[i].titleRect DO
      BEGIN
      WinDrawChars (title^.chars, title^.len, endOfLastTitleRect, 2);
      topleft.x := endOfLastTitleRect;
      topleft.y := 0;
      titleLen := title^.len;
      extent.x  := titleLen * CharWidth;
      extent.y  := LineHeight + 4;
      endOfLastTitleRect := topLeft.x + extent.x;
      END;
    FreeString (title);
    END;
  END;
WinInvertRectangle (menuBar.barRect);
FreeString (menuStr);
turncursoron;
END;
$EJ

{-----------------------------------------------------------}
{                       MenuRoutine                         }
{-----------------------------------------------------------}

PROCEDURE MenuRoutine (i: WORD; menuStr: StringPtr);
BEGIN
IF (i <= menuBar.numMenus) THEN WITH menuBar.menu[i] DO
  BEGIN
  FreeString (items);
  items      := menuStr;
  IF (items^.chars[items^.len] <> '~') THEN AppendAnyChar (items, '~');
  numItems   := ItemCount (menuStr^.chars, menuStr^.len, '~', maxItemLen);
  enableBits := 0;
  END;
END;
$EJ

{-----------------------------------------------------------}
{                      HighlightMenu                        }
{-----------------------------------------------------------}

PROCEDURE HighlightMenu (ith: WORD);
VAR
  item:         StringPtr;
  i:            WORD;
  error:        WORD;
  x, y:         Integer;
  lineY:        Integer;
  tq100Avoider: Integer;

BEGIN
IF (menuBar.curMenu <> ith) THEN
  WITH menuBar, menuBar.menu[ith] DO
    BEGIN
    turncursoroff;
    {----------------------------------}
    { remove existing highlighted menu }
    {----------------------------------}
    UnhighlightMenu;

    {-----------------------}
    { highlight the new one }
    {-----------------------}
    MenuBar.curMenu := ith;
    InvertTitleRect (titleRect);
    IF (items <> NIL) THEN
      BEGIN
      { calc and frame 3d rect }
      textRect.topLeft.x := titleRect.topleft.x;
      textRect.topLeft.y := LineHeight + 3;
      tq100Avoider := maxItemLen;
      textRect.extent.x  := (tq100Avoider + 2) * CharWidth;
      tq100Avoider := numItems;
      textRect.extent.y  := (tq100Avoider * MenuLineHeight) + 2;

      { save, erase and draw the 3d menu rectangle }
      WinGetFrameRect   (shadedRect, textRect, obscuredRect);
      menuBar.savedBits := WinSaveBits (obscuredRect, error);
      WinEraseRectangle (textRect);
      WinDrawFrame      (shadedRect, textRect);

      { draw the chars }
      x := textRect.topLeft.x + CharWidth;
      y := textRect.topLeft.y +1 + (MenuLineGap DIV 2);
      FOR i := 1 TO numItems DO
        BEGIN
        item := SubStringLit (items^.chars,'~',i);
        IF (item^.len = 1) AND (item^.chars[1] = '-') THEN
          BEGIN
          MenuDisableItem (ith{menu}, i, true);
          lineY := y + (LineHeight DIV 2);
          WinDrawLine (textRect.topLeft.x, lineY,
                       textRect.topLeft.x +textRect.extent.x -1, lineY)
          END
        ELSE
          BEGIN
          IF MenuItemEnabled (i)
            THEN WinDrawChars     (item^.chars,item^.len,x,y)
            ELSE WinDrawGrayChars (item^.chars,item^.len,x,y);
          END;
        y := y + MenuLineHeight;
        FreeString (item);
        END;
      END;
    turncursoron;
    END;
END;
$EJ

{-----------------------------------------------------------}
{                     UnHighlightMenu                       }
{-----------------------------------------------------------}

PROCEDURE UnHighlightMenu;
VAR
  error: WORD;

BEGIN
IF (menuBar.curMenu <> 0) THEN
  WITH menuBar.menu[menuBar.curMenu] DO
    BEGIN
    turncursoroff;
    InvertTitleRect (titleRect);
    menuBar.curMenu := 0;
    menuBar.curItem := 0;
    IF (items <> NIL) THEN
      BEGIN
      WinRestoreBits (menuBar.savedBits, menuBar.obscuredRect, error);
      END;
    turncursoron;
    END;
END;
$EJ

{-----------------------------------------------------------}
{                     HighlightItem                         }
{-----------------------------------------------------------}

PROCEDURE HighlightItem (newCurItem: WORD);
VAR
  itemRect: Rectangle;

BEGIN
WITH menuBar DO
  IF (newCurItem <> curItem) THEN
    BEGIN
    turncursoroff;
    UnHighlightItem;
    curItem := newCurItem;
    IF (newCurItem <> 0) THEN
      BEGIN
      GetItemRect (textRect, itemRect, curItem);
      WinInvertRectangle (itemRect);
      END;
    turncursoron;
    END;
END;

{-----------------------------------------------------------}
{                     UnHighlightItem                       }
{-----------------------------------------------------------}

PROCEDURE UnHighlightItem;
VAR
  itemRect: Rectangle;

BEGIN
WITH menuBar DO
  IF (menuBar.curItem <> 0) THEN
    BEGIN
    turncursoroff;
    GetItemRect (textRect, itemRect, curItem);
    WinInvertRectangle (itemRect);
    curItem := 0;
    turncursoron;
    END;
END;
$EJ

{-----------------------------------------------------------}
{                     InvertTitleRect                       }
{ The pen sensitive area of the title includes the entire   }
{ height of the menu bar.  but you don't want to highlight  }
{ the entire bar.  use this procedure for highlighting      }
{-----------------------------------------------------------}

PROCEDURE InvertTitleRect (VAR r: Rectangle);
VAR
  newR: Rectangle;

BEGIN
newR.topleft.x := r.topleft.x;
newR.topleft.y := 1;
newR.extent.x  := r.extent.x;
newR.extent.y  := LineHeight+2;
WinInvertRectangle (newR);
END;

{-----------------------------------------------------------}
{                       PtInCurMenu                         }
{-----------------------------------------------------------}

FUNCTION PtInCurMenu (x,y: Integer; VAR thisItem: WORD): Boolean;
VAR
  inMenu: Boolean;

BEGIN
WITH menuBar DO
  BEGIN
  inMenu := false;
  IF (curMenu <> 0) THEN inMenu := PtInRect(x, y, textRect);

  {------------------------}
  { set thisItem parameter }
  {------------------------}
  IF inMenu THEN WITH menuBar.menu[menuBar.curMenu] DO
    BEGIN
    thisItem := (y -textRect.topleft.y - 1 +MenuLineHeight) DIV MenuLineHeight;
    { check for bottom bit of rect algorithm error }
    IF (thisItem > numItems) THEN thisItem := numItems;
    IF (NOT MenuItemEnabled(thisItem)) THEN thisItem := 0;
    END;
  END;
PtInCurMenu := inMenu;
END;

{-----------------------------------------------------------}
{                       GetItemRect                         }
{ Given a rectangle of a menu, return the rect of item i    }
{-----------------------------------------------------------}

PROCEDURE GetItemRect (VAR menuR, itemR: Rectangle; i: WORD);
VAR
  iInt: Integer;  { This is here to avoid calling Tq_100 }

BEGIN
iInt := i;

itemR.topleft.x := menuR.topleft.x+1;
itemR.extent.x  := menuR.extent.x-2;
itemR.extent.y  := MenuLineHeight;
itemR.topleft.y := (menuR.topleft.y + 1) + ((iInt-1) * MenuLineHeight);
END;
$EJ

{-----------------------------------------------------------}
{                    MenuHandleEvent                        }
{-----------------------------------------------------------}

FUNCTION MenuHandleEvent (VAR event: EventType): Boolean;
VAR
  i, error:     WORD;
  penInBar:     Boolean;
  penDown:      Boolean;
  penInATitle:  Boolean;
  penInItem:    Boolean;
  penInCurMenu: Boolean;
  itemRect:     Rectangle;
  thisItem:     WORD;
  x,y:          Integer;
  dummy:        WORD;
  menuItemID:   WORD;
  menuItemBits: WORD;
  newEvent:     EventType;

BEGIN
MenuHandleEvent := false;

IF (event.eType = penDownEvent) THEN WITH menuBar DO
  BEGIN
  {---------------------------}
  { initialize some variables }
  {---------------------------}
  penInBar := PtInRect (event.screenX, event.screenY, barRect);

  {-------------------------------}
  { if pen goes down outside of   }
  { bar or curMenu then unhilight }
  {-------------------------------}
  IF NOT (penInBar OR PtInCurMenu(event.screenX, event.screenY, dummy)) THEN
    BEGIN
    UnhighlightMenu;
    END

  {--------------------------------------}
  { pen went down in menu bar or curMenu }
  {--------------------------------------}
  ELSE
    BEGIN
    MenuHandleEvent := true;
    x := event.screenx;
    y := event.screeny;

    {-------------------------}
    { follow movements of pen }
    { as long as it stays down}
    {-------------------------}
    REPEAT
      {------------------------------------------}
      { highlight item if pen is in current menu }
      {------------------------------------------}
      penInCurMenu := PtInCurMenu(x,y,thisItem);
      IF penInCurMenu THEN
        BEGIN
        HighlightItem (thisItem);
        END

      {----------------------------}
      { check if pen is in a title }
      {----------------------------}
      ELSE
        BEGIN
        UnHighlightItem;
        penInBar := PtInRect (x, y, barRect);
        penInATitle := false;
        IF penInBar THEN
          FOR i := 1 TO numMenus DO WITH menu[i] DO
            BEGIN
            IF PtInRect (x,y,titleRect) THEN
              BEGIN
              HighlightMenu (i);
              penInATitle := true;
              END;
            END;
        END;

      {---------------------------------------------}
      { if pen is elsewhere in bar then unhighlight }
      {---------------------------------------------}
      IF penInBar AND NOT penInATitle THEN
        BEGIN
        UnHighlightMenu;
        END;
      GetPt (x,y,penDown,error);
    UNTIL NOT penDown;

    {--------------------------}
    { did pen come up in menu? }
    {--------------------------}
    IF (curItem <> 0) THEN
      BEGIN
      { Check to see if there is a corresponding menu/item ID }
      menuItemID := 0;
      menuItemBits := (curMenu * 2048) + (curItem * 64);
      FOR i := 1 TO numMenuIDs DO
        BEGIN
        IF BitAnd (menuIDs[i], menuItemMask) = menuItemBits THEN
          menuItemID := BitAnd (menuIDs[i], idMask);
        END;

      newEvent.eType := menuEvent;
      newEvent.data1 := curMenu;
      newEvent.data2 := curItem;
      newEvent.data3 := menuItemID;
      AddEventToQueue (newEvent);
      {------------------------------------------}
      { unhighlightmenu AFTER sending menu event }
      {------------------------------------------}
      UnHighlightMenu;
      END;
    END;
  END;
END;
.
